﻿#include <iostream>
#include <iomanip>
#include <set>
#include <map>
#include <vector>
#include <algorithm>
#define ll long long
#define ld long double

using namespace std;

const ll inf = 1e18;
const ll MOD = 998244353;

// login: r10022747
// password: GoIwuZ
// cups.online/ru

ll binPow(ll n, ll p) {
	ll ans = 1;
	while (p) {
		if (p % 2 == 0) {
			p /= 2;
			n = (n * n) % MOD;
		} else {
			p--;
			ans = (ans * n) % MOD;
		}
	}
	return ans;
}

int main() {
	ios::sync_with_stdio(false);
	cin.tie(0);

	ll t;
	cin >> t;
	while (t--) {
		ll n, m;
		cin >> n >> m;
		vector<vector<ll>> dp(n + 1, vector<ll>(n + 1, 0));
		dp[1][1] = m;
		dp[0][0] = 1;
		for (ll i = 2; i <= n; i++) {
			for (ll j = 1; j <= i; j++) {
				for (ll k = 1; k < j; k++) {
					dp[i][j] += (dp[i - k][j] * (m - 1)) % MOD;
					dp[i][j] %= MOD;
				}
				for (ll k = 0; k <= j; k++) {
					if (i == j) {
						dp[i][j] += (dp[i - j][k] * m) % MOD;
					} else {
						dp[i][j] += (dp[i - j][k] * (m - 1)) % MOD;
					}
					dp[i][j] %= MOD;
				}
			}
		}
		ll sum = 0;
		for (ll i = 1; i <= n; i++) {
			sum = (sum + (dp[n][i] * i) % MOD) % MOD;
		}
		ll d = 1;
		for (ll i = 1; i <= n; i++) {
			d = (d * m) % MOD;
		}
		cout << sum * binPow(d, MOD - 2) % MOD << "\n";
	}

	return 0;
}